import java.io.*;
import java.nio.file.*;
import java.nio.file.attribute.*;
import java.util.*;

class FilesAndFolders {

static void getSpaceOfStore(FileStore store) throws IOException {
	final long mega = 1024*1024;
	long gesamt = store.getTotalSpace()/mega;
	long belegt = (store.getTotalSpace()-store.getUsableSpace())/mega;
	long frei = store.getUsableSpace()/mega;
	System.out.printf("%-20s %12d %12d %12d\n", store, gesamt, belegt, frei);
}

	public static void main(String[] args)  throws IOException {
		// Path-Methoden
		System.out.println("Path-Methoden:");
		Path p1 = Path.of("E:", "Data", "ausgabe.txt");
		System.out.println("p1.getFileName(): " + p1.getFileName());
		System.out.println("p1.getParant(): " + p1.getParent());
		System.out.println("p1.getNameCount(): " + p1.getNameCount());
		System.out.println("p1.getRoot(): " + p1.getRoot());
		System.out.println("p1.getName(0): " + p1.getName(0));
		System.out.println("p1.subpath(0, 2): " + p1.subpath(0, 2));
		System.out.println("p1.isAbsolute(): " + p1.isAbsolute());
		System.out.println("p1.subpath(0, 2).isAbsolute(): " + p1.subpath(0, 2).isAbsolute());
		Path dirr = Path.of("E:", "data");
		Path datei = dirr.resolve("Ausgabe.txt");
		System.out.println("datei: " + datei);
		Path d1=Path.of("E:", "Data", "a.txt");
		Path d2=d1.resolveSibling("b.txt");
		System.out.println("d2: " + d2);
		File f = p1.toFile();
		System.out.println(f);
		System.out.println("p1.toUri(): " + p1.toUri());
		Path p2 = Path.of("E:/data/Ausgabe.txt");
		System.out.println(p2.compareTo(p1));
		Path p3 = Path.of("E:/data/../data/ausgabe.txt");
		System.out.println(p3.compareTo(p1));
		System.out.println(p3.normalize().compareTo(p1));
		Path dir = Path.of("E:", "data");

		// Sich später auf ein Testergebnis zu verlassen, ist unsicher (TOCTTOU-Falle).
		if (Files.exists(dir))
			System.out.println(dir + " existiert bereits.");
		else
			if (Files.notExists(dir))
				System.out.println(dir + " existiert noch nicht");
			else
				System.out.println(dir + " hat einen unbekannten Status.");

		// Verzeichnis ggf. erstellen
		dir = Path.of("E:", "data", "io", "2");
		try {
			Files.createDirectories(dir);
			System.out.println(dir + " erstellt");
		} catch (FileAlreadyExistsException ae) {
			System.err.println(dir + " existiert, ist aber kein Verzeichnis.");
			throw ae;
		}

		// Datei explizit erstellen
		Path file = null;
		try {
			file = dir.resolve("Ausgabe.dat");
			Files.createFile(file);
			System.out.println(file + " erstellt");
		} catch (FileAlreadyExistsException ae) {
			System.err.println(file + " existiert bereits.");
		}

		// Daten in die Ausgabedatei schreiben
		byte[] arr = {1, 2, 3};
		Files.write(file, arr);
		System.out.println("Daten geschrieben in Datei " + file);

		// Datum der letzten Modifikation abfragen
		System.out.println(Files.getLastModifiedTime(file));

		// Über ein Dateisystemobjekt informieren
		System.out.println("\nEigenschaften von    " + file);
		System.out.println(" Größe in Bytes:     " + Files.size(file));
		System.out.println(" Letzte Änderung:    " + Files.getLastModifiedTime(file));
		System.out.println(" Datei:              " + Files.isRegularFile(file));
		System.out.println(" Verzeichnis:        " + Files.isDirectory(file));
		System.out.println(" Symb. Link:         " + Files.isSymbolicLink(file));
		System.out.println(" Schreiben möglich:  " + Files.isWritable(file));

		System.out.println("\nAbfrage eines Informationspakets");
		BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class);
//		BasicFileAttributes attr = Files.readAttributes(name, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
		System.out.println(" Größe in Bytes:     " + attr.size());

		// Datum der letzten Modifikation ändern
		System.out.println("\nDatum der letzten Modifikation setzen\n vorher:    " + Files.getLastModifiedTime(file));
		Calendar cal = Calendar.getInstance();
		cal.set(1980, Calendar.APRIL, 1, 0, 0, 0);
		Files.setLastModifiedTime(file, FileTime.fromMillis(cal.getTimeInMillis()));
		System.out.println(" nachher:   " + Files.getLastModifiedTime(file));

		// Verzeichnisinhalte auflisten
		System.out.println("\nDateien im Verzeichnis " + dir);
		try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir)) {
			for (Path path: ds)
				System.out.println(" " + path.getFileName());
		}

		// Datei kopieren
		Files.copy(file, dir.resolve("Kopie.dat"), StandardCopyOption.REPLACE_EXISTING);

		// Ordner kopieren
		Path targetDir = dir.resolveSibling("3");
		try {
			Files.copy(dir, targetDir);
		} catch (FileAlreadyExistsException ae) {
			System.out.printf("\n%s existiert bereits.\n", targetDir);
		}

		// Datei umbenennen
		Files.move(file, file.resolveSibling("Umbenannt.dat"), StandardCopyOption.REPLACE_EXISTING);
		System.out.println("\nDatei " + file + " umbenannt");

		// Datei verschieben
		Path umb = dir.resolve("Umbenannt.dat");
		Files.move(umb, dir.getParent().resolve("Verschoben.dat"),
				StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
//		Files.move(umb, dir.getParent().resolve(umb.getFileName()),
//				StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
		System.out.println("\nDatei " + dir.resolve("Umbenannt.dat") + " verschoben");

		// Dateien löschen
		try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir)) {
			System.out.println("\nDateien löschen:");
			for (Path path: ds) {
				Files.delete(path);
				System.out.println(" " + path.getFileName());
			}
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}

		// Verzeichnisse löschen
		try {
			Files.delete(dir.resolveSibling("3"));
			Files.delete(dir);
			System.out.println("\nVerzeichnisse gelöscht");
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}

		// Nutzbares Speichervolumen ermitteln
        System.out.printf("\n%-20s %12s %12s %12s\n", "Laufwerk", "Gesamt (MB)", "Belegt (MB)", "Frei (MB)");
        FileSystem fs = FileSystems.getDefault();
		try {
			for (FileStore store: fs.getFileStores())
				getSpaceOfStore(store);
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}
}